% FOR HELICOPTER NR 3-10
% This file contains the initialization for the helicopter assignment in
% the course TTK4115. Run this file before you execute QuaRC_ -> Build 
% to build the file heli_q8.mdl.

% Oppdatert hsten 2006 av Jostein Bakkeheim
% Oppdatert hsten 2008 av Arnfinn Aas Eielsen
% Oppdatert hsten 2009 av Jonathan Ronen
% Updated fall 2010, Dominik Breu
% Updated fall 2013, Mark Haring
% Updated spring 2015, Mark Haring


%%%%%%%%%%% Calibration of the encoder and the hardware for the specific
%%%%%%%%%%% helicopter
Joystick_gain_x = 1;
Joystick_gain_y = 1;


%%%%%%%%%%% Physical constants
g = 9.81; % gravitational constant [m/s^2]
l_c = 0.46; % distance elevation axis to counterweight [m]
l_h = 0.66; % distance elevation axis to helicopter head [m]
l_p = 0.175; % distance pitch axis to motor [m]
m_c = 1.92; % Counterweight mass [kg]
m_p = 0.72; % Motor mass [kg]

%%%%%%%%%%% Constants found at the lab
e_offset = 0.52;

vs_0 = 7.2;

p_offset = 0;

k_f = -(m_c*g*l_c - 2*m_p*g*l_h)/(vs_0*l_h);

j_p = 2 * m_p * l_p^2;
j_e = m_c * l_c^2 + 2 * m_p * l_h^2;
j_l = m_c * l_c^2 + 2 * m_p * (l_h^2 + l_p^2);

k_1 = l_p * k_f /j_p;

k_2 = k_f*l_h/j_e;

%%%%%%%%%%% LQR Regulator
A = [
  [0 1 0];
  [0 0 0];
  [0 0 0];
];

B = [
  [0 0];
  [0 k_1];
  [k_2 0];
];

C = [
  [0 1 0];
  [0 0 1];
];

Q = diag([1 1 1]);

R = diag([100 100]);

K = lqr(A, B, Q, R);

%F = inv(C*inv(B*K-A)*B)

F = [
   [K(1, 1) K(1, 3)];
   [K(2, 1) K(2, 3)];
];